/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;

@Singleton
public class PlantAssetModifier {
    private Entity currentEntity;
    private final PlantEntityAssetDictionary assetDictionary;
    private EntityAssetType branchAssetType = new EntityAssetType("PLANT_BRANCHES");
    private EntityAssetType leafAssetType = new EntityAssetType("PLANT_LEAVES");
    private EntityAssetType fruitAssetType = new EntityAssetType("PLANT_FRUIT");

    @Inject
    public PlantAssetModifier(PlantEntityAssetDictionary assetDictionary) {
        this.assetDictionary = assetDictionary;
    }

    public void setEntity(Entity entity) {
        this.currentEntity = entity;
    }

    public void changePlantSize(int newSize) {
        PhysicalEntityComponent physicalComponent = this.currentEntity.getPhysicalEntityComponent();
        PlantEntityAttributes attributes = (PlantEntityAttributes)physicalComponent.getAttributes();
        attributes.setCurrentTileHeight(newSize);
        this.resetAssetMap(physicalComponent, attributes);
    }

    public void changeSpecies(PlantSpecies selectedSpecies) {
        PhysicalEntityComponent physicalComponent = this.currentEntity.getPhysicalEntityComponent();
        PlantEntityAttributes attributes = (PlantEntityAttributes)physicalComponent.getAttributes();
        attributes.setSpecies(selectedSpecies);
        this.resetAssetMap(physicalComponent, attributes);
    }

    private void resetAssetMap(PhysicalEntityComponent physicalComponent, PlantEntityAttributes attributes) {
        PlantEntityAsset newBaseAsset = this.assetDictionary.getPlantEntityAsset(this.branchAssetType, attributes);
        physicalComponent.setBaseAsset(newBaseAsset);
        physicalComponent.getTypeMap().clear();
        physicalComponent.getTypeMap().put(this.branchAssetType, newBaseAsset);
        PlantEntityAsset leafAsset = this.assetDictionary.getPlantEntityAsset(this.leafAssetType, attributes);
        physicalComponent.getTypeMap().put(this.leafAssetType, leafAsset);
        if (attributes.getSpecies().getFruit() != null) {
            PlantEntityAsset fruitAsset = this.assetDictionary.getPlantEntityAsset(this.fruitAssetType, attributes);
            physicalComponent.getTypeMap().put(this.fruitAssetType, fruitAsset);
        }
    }
}

